/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class ForgeVersion {
    public static final int majorVersion = 10;
    public static final int minorVersion = 13;
    public static final int revisionVersion = 3;
    public static final int buildVersion = 1403;
    private static Status status = Status.PENDING;
    private static String target = null;

    public static int getMajorVersion() {
        return 10;
    }

    public static int getMinorVersion() {
        return 13;
    }

    public static int getRevisionVersion() {
        return 3;
    }

    public static int getBuildVersion() {
        return 1403;
    }

    public static Status getStatus() {
        return status;
    }

    public static String getTarget() {
        return target;
    }

    public static String getVersion() {
        return String.format("%d.%d.%d.%d", 10, 13, 3, 1403);
    }

    public static void startVersionCheck() {
        new Thread("Forge Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL("http://files.minecraftforge.net/maven/net/minecraftforge/forge/promotions_slim.json");
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String rec = (String)promos.get("1.7.10-recommended");
                    String lat = (String)promos.get("1.7.10-latest");
                    DefaultArtifactVersion current = new DefaultArtifactVersion(ForgeVersion.getVersion());
                    if (rec != null) {
                        DefaultArtifactVersion recommended = new DefaultArtifactVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(new DefaultArtifactVersion(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = lat;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = rec;
                        }
                    } else if (lat != null) {
                        if (current.compareTo(new DefaultArtifactVersion(lat)) < 0) {
                            status = Status.BETA_OUTDATED;
                            target = lat;
                        } else {
                            status = Status.BETA;
                        }
                    } else {
                        status = Status.BETA;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = Status.FAILED;
                }
            }
        }.start();
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED,
        AHEAD,
        BETA,
        BETA_OUTDATED;

    }
}

